"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = serverError;
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function serverError(error) {
  if (!(error instanceof Error)) {
    throw new Error('The provided argument must be instance of Error.');
  }
  const customError = {
    statusCode: error.statusCode || 500,
    body: {
      message: error.message || 'Internal Server Error'
    }
  };
  if (error.body) {
    customError.body.attributes = {
      body: error.body
    };
  }
  return customError;
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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